% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storage.r
\name{ds.storage.file.csv.load}
\alias{ds.storage.file.csv.load}
\title{Load data from CSV file into `xts` object}
\usage{
ds.storage.file.csv.load(file, date.col = NULL,
  date.format = "\%Y-\%m-\%d")
}
\arguments{
\item{file}{CSV file}

\item{date.col}{date column}

\item{date.format}{date format}
}
\value{
xts object with loaded data
}
\description{
Load data from CSV file into `xts` object
}
\examples{
 # get sample of the fake stock data
 data = ds.getSymbol.fake.stock.data('dummy', from = '2018-02-01', to = '2018-02-13')
 filename = file.path(tempdir(), 'dummy.csv')
 ds.storage.file.csv.save(data, filename)
 ds.storage.file.csv.load(filename)

}
