% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtsplot.r
\name{rtsplot.y.highlight}
\alias{rtsplot.y.highlight}
\title{Highlight horizontal segments}
\usage{
rtsplot.y.highlight(highlight, col = rtsplot.theme()$col.y.highlight)
}
\arguments{
\item{highlight}{segments to highlight along Y axis}

\item{col}{highlight color, \strong{defaults to rtsplot.control$col.y.highlight}}
}
\value{
nothing
}
\description{
Highlight horizontal segments
}
\examples{
# generate time series data
y = rtsplot.fake.stock.data(1000)

rsi = TTR::RSI(y, 20)	
 	
#set up two regions for graphs candlestick price data on top 2/3 of the plot
#and rsi on the bottom 1/3 of the plot
layout(c(1,1,2))  
	
rtsplot(y, type = 'line', plotX = FALSE)
  rtsplot.legend('SPY', 'grey70', y)

rtsplot(rsi, type = 'l')

col = grDevices::adjustcolor(c('green','red'), 80/255)
rtsplot.y.highlight(col=col[1], highlight=c(50,100))	
rtsplot.y.highlight(col=col[2], highlight=c(0,50))	
	
abline(h = 50, col = 'gray20')

rtsplot.legend('RSI(20)', 'black', rsi)

}
