% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtsplot.r
\name{rtsplot.candle}
\alias{rtsplot.candle}
\title{Create Candle Plot}
\usage{
rtsplot.candle(
  y,
  col = rtsplot.candle.col(y),
  border = rtsplot.theme()$col.border
)
}
\arguments{
\item{y}{\code{\link{xts}} object}

\item{col}{color for bars, \strong{defaults to rtsplot.candle.col}}

\item{border}{border color, \strong{defaults to rtsplot.theme()$col.border}}
}
\value{
nothing
}
\description{
Plot candles if dx is sufficient otherwise ohlc or bars
}
\examples{
y = rtsplot.fake.stock.data(50, ohlc=TRUE)
symbol = 'SPY'
	
 # plot
 layout(1)
 rtsplot(y, type = 'n')
 rtsplot.candle(y)
rtsplot.legend(symbol, 'black', y)

}
