% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collections.R
\name{lookup_collections}
\alias{lookup_collections}
\title{Get collections by user or status id.}
\usage{
lookup_collections(id, n = 200, parse = TRUE, token = NULL, ...)
}
\arguments{
\item{id}{required The identifier of the Collection to return results for
e.g., "custom-539487832448843776"}

\item{n}{Specifies the maximum number of results to include in
the response. Specify count between 1 and 200.}

\item{parse}{Logical indicating whether to convert response object into
nested list. Defaults to true.}

\item{token}{Every user should have their own Oauth (Twitter API) token. By
default \code{token = NULL} this function looks for the path to a saved
Twitter token via environment variables (which is what `create_token()`
sets up by default during initial token creation). For instruction on how
to create a Twitter token see the tokens vignette, i.e.,
`vignettes("auth", "rtweet")` or see \code{?tokens}.}

\item{...}{Other arguments passed along to composed request query.}
}
\value{
Return object converted to nested list if parsed otherwise
  an HTTP response object is returned.
}
\description{
Return data for specified collection (themed grouping of Twitter statuses).
Response data varies significantly compared to most other users and tweets
data objects returned in this package.
}
\examples{

\dontrun{

## lookup a specific collection
cc <- lookup_collections("custom-539487832448843776")

## inspect data
str(cc)

}

}
