% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_plot.R
\name{ts_plot}
\alias{ts_plot}
\title{Plots tweets data as a time series-like data object.}
\usage{
ts_plot(data, by = "days", trim = 0L, tz = "UTC", ...)
}
\arguments{
\item{data}{Data frame or grouped data frame.}

\item{by}{Desired interval of time expressed as numeral plus one of
"secs", "mins", "hours", "days", "weeks", "months", or
"years". If a numeric is provided, the value is assumed to be in
seconds.}

\item{trim}{The number of observations to drop off the beginning
and end of the time series.}

\item{tz}{Time zone to be used, defaults to "UTC" (Twitter default)}

\item{...}{Other arguments passed to
\code{\link[ggplot2]{geom_line}}.}
}
\value{
If
  \href{https://cran.r-project.org/package=ggplot2}{ggplot2} is
  installed then a \code{\link[ggplot2]{ggplot}} plot object.
}
\description{
Creates a ggplot2 plot of the frequency of tweets over a specified
interval of time.
}
\examples{

\dontrun{

## search for tweets containing "rstats"
rt <- search_tweets("rstats", n = 10000)

## plot frequency in 1 min intervals
ts_plot(rt, "mins")

## plot multiple time series--retweets vs non-retweets
rt \%>\%
  dplyr::group_by(is_retweet) \%>\%
  ts_plot("hours")

## compare account activity for some important US political figures
tmls <- get_timeline(
  c("SenSchumer", "SenGillibrand", "realDonaldTrump"),
  n = 3000
)

## examine all twitter activity using weekly intervals
ts_plot(tmls, "weeks")

## group by screen name and plot each time series
ts_plot(dplyr::group_by(tmls, screen_name), "weeks")

## group by screen name and is_retweet
tmls \%>\%
  dplyr::group_by(tmls, screen_name, is_retweet) \%>\%
  ts_plot("months")

}
}
\concept{ts_data}
