% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/close_matching_samples.R
\name{close_matching_samples}
\alias{close_matching_samples}
\title{check for matching (or close to matching) genotypes in a data frame}
\usage{
close_matching_samples(
  D,
  gen_start_col,
  min_frac_non_miss = 0.7,
  min_frac_matching = 0.9
)
}
\arguments{
\item{D}{a two-column format genetic dataset, with "repunit", "collection", and "indiv"
columns, as well as a "sample_type" column that has entried either of "reference" or "mixture"
or both.}

\item{gen_start_col}{the first column of genetic data in \code{reference}}

\item{min_frac_non_miss}{the fraction of loci that the pair must share non missing in order to be reported}

\item{min_frac_matching}{the fraction of shared non-missing loci that must be shared between the indivdiuals
to be reported as a matching pair.}
}
\value{
a tibble ...
}
\description{
Super simple function that looks at all pairs of fish from the data frame and
returns a tibble that includes those which shared a fraction >= than min_frac_non_miss
of the genotypes not missing in either fish, and which were matching at a fraction >= min_frac_matching
of those non-missing pairs of genotypes.
}
\examples{
# one pair found in the interal alewife data set:
close_matching_samples(alewife, 17)
}
