% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed-all-the-things.R
\name{starspace_load_model}
\alias{starspace_load_model}
\title{Load a Starspace model}
\usage{
starspace_load_model(object, method = c("ruimtehol", "tsv-data.table"), ...)
}
\arguments{
\item{object}{the path to a Starspace model on disk}

\item{method}{character indicating the method of loading. Possible values are 'ruimtehol' and 'tsv-data.table'. Defaults to 'ruimtehol'.
\itemize{
\item{method \code{'ruimtehol'} loads the model, embeddings and labels which were saved with saveRDS by calling \code{\link{starspace_save_model}} and re-initilises a new Starspace model with the embeddings and the same parameters used to build the model}
\item{method \code{'tsv-data.table'} loads the embedding which were saved as a tab-delimited flat file using the fast data.table fread function - see \code{\link{starspace_save_model}}}
}}

\item{...}{further arguments passed on to \code{\link{starspace}} in case of method 'tsv-data.table'}
}
\value{
an object of class textspace
}
\description{
Load a Starspace model
}
\examples{
data(dekamer, package = "ruimtehol")
dekamer$text <- strsplit(dekamer$question, "\\\\W")
dekamer$text <- lapply(dekamer$text, FUN = function(x) setdiff(x, ""))
dekamer$text <- sapply(dekamer$text, 
                       FUN = function(x) paste(x, collapse = " "))

dekamer$target <- as.factor(dekamer$question_theme_main)
codes <- data.frame(code = seq_along(levels(dekamer$target)), 
                    label = levels(dekamer$target), stringsAsFactors = FALSE)
dekamer$target <- as.integer(dekamer$target)
set.seed(123456789)
model <- embed_tagspace(x = dekamer$text, 
                        y = dekamer$target, 
                        early_stopping = 0.8,
                        dim = 10, minCount = 5)
starspace_save_model(model, file = "textspace.ruimtehol", method = "ruimtehol",
                     labels = codes)
model <- starspace_load_model("textspace.ruimtehol", method = "ruimtehol")


## clean up for cran
file.remove("textspace.ruimtehol")
}
\seealso{
\code{\link{starspace_save_model}}
}
