% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-SparreAndersen.R
\name{SparreAndersen}
\alias{SparreAndersen}
\title{Constructs an object of SparreAndersen S4 class}
\usage{
SparreAndersen(initial_capital = NULL, premium_rate = NULL,
  claim_interarrival_generator = NULL, claim_interarrival_parameters = NULL,
  claim_size_generator = NULL, claim_size_parameters = NULL)
}
\arguments{
\item{initial_capital}{a length one numeric non-negative vector specifying an
initial capital. Default: \code{0}.}

\item{premium_rate}{a length one numeric non-negative vector specifying a
premium rate. Default: \code{1}.}

\item{claim_interarrival_generator}{a function indicating the random
generator of claims' interarrival times. Default: \code{rexp}.}

\item{claim_interarrival_parameters}{a named list containing parameters for
the random generator of claims' interarrival times. Default:
\code{list(rate = 1)}.}

\item{claim_size_generator}{a function indicating the random generator of
claims' sizes. Default: \code{rexp}.}

\item{claim_size_parameters}{a named list containing parameters for the
random generator of claims' sizes. Default: \code{list(rate = 1)}.}
}
\value{
An object of \linkS4class{SparreAndersen} class.
}
\description{
\code{SparreAndersen()} constructs an object of \code{SparreAndersen} S4
class.
}
\details{
The function constructs an object of a formal S4 class
\code{SparreAndersen}, a representation of an extension of
Cramer-Lundberg model that allows for non-exponential interarrival times and
defined as follows:
\deqn{X(t) = u + ct - \sum_{i=1}^{N(t)} Y_i,}
where \eqn{u} is the initial capital (\code{initial_capital}), \eqn{c} is the
premium rate (\code{premium_rate}), \eqn{N(t)} is the renewal process defined
by distribution of interarrival times (\code{claim_interarrival_generator}
and \code{claim_interarrival_parameters}), \eqn{Y_i} are iid claim sizes
(\code{claim_size_generator} and \code{claim_size_parameters}).
}
\examples{
model <- SparreAndersen(
  initial_capital = 10,
  premium_rate = 1,
  claim_interarrival_generator = rexp,
  claim_interarrival_parameters = list(rate = 1),
  claim_size_generator = rexp,
  claim_size_parameters = list(rate = 1)
)

}
\references{
\itemize{
\item Andersen, E. Sparre. \emph{On the collective theory of risk in case of
contagion between claims}. Transactions of the XVth International Congress
of Actuaries, 2(6), 1957.
\item Thorin O. \emph{Some Comments on the Sparre Andersen Model in the Risk
Theory}. ASTIN Bulletin: The Journal of the IAA, 8(1):104-125, 1974.
}
}
\seealso{
\code{\link{CramerLundberg}},
\code{\link{CramerLundbergCapitalInjections}},
\code{link{SparreAndersenCapitalInjections}}.
}
