% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ruin_probability.R
\name{ruin_probability}
\alias{ruin_probability}
\title{Estimate a ruin probability for a finite time horizon}
\usage{
ruin_probability(model, time_horizon, simulation_number = NULL,
  ci_level = NULL, parallel = NULL, return_paths = NULL)
}
\arguments{
\item{model}{an S4 object indicating a risk model (e.g.,
\linkS4class{CramerLundberg}).}

\item{time_horizon}{a length one numeric finite vector specifying the time at
which the ruin probability should be estimated.}

\item{simulation_number}{a length one numeric vector giving the number of
simulations that should be performed. Default: \code{10000}.}

\item{ci_level}{a length one numeric vector between 0 and 1 indicating the
level of the confidence interval of the ruin probability. Default:
\code{0.95}.}

\item{parallel}{a length one logical vector indicating whether the parallel
computing should be used. Default: \code{TRUE}.}

\item{return_paths}{a length one logical vector indicating whether a list of
simulated paths should be returned. Default: \code{FALSE}.}
}
\value{
A list of two elements: a numeric vector of lower bound of CI,
estimate, and upper bound of CI of the ruin probability; and optionally the
list of simulated paths.
}
\description{
\code{ruin_probability} simulates paths for a given risk \code{model} and
returns a crude Monte-Carlo estimate of the ruin probability for the finite
time horizon.
}
\details{
The function uses a parallel computing from the package
\code{\link{parallel}} (if \code{parallel} is TRUE). The package sets up
\code{\link{RNGkind}} to \code{"L'Ecuyer-CMRG"} for a safe seeding (see
\code{\link{nextRNGStream}}) when it is loaded, so that user does not have
to take care of seeds / RNGs. Further, the function allows computing the
confidence interval, assuming the normal distribution of the ruin
probability (thanks to CLT).
}
\examples{
model <- CramerLundberg(initial_capital = 0,
                        premium_rate = 1,
                        claim_poisson_arrival_rate = 1,
                        claim_size_generator = rexp,
                        claim_size_parameters = list(rate = 1))
ruin_probability(model = model,
                 time_horizon = 10,
                 simulation_number = 100,
                 return_paths = TRUE,
                 parallel = FALSE)

}
