testthat::test_that("Grouped Character Combinations Function Correctly", {
    testthat::expect_equal(runes::runes("th"), "\u16a6")
    testthat::expect_equal(runes::runes("tth"), "\u16cf\u16a6")
    testthat::expect_identical(runes::runes("th"), "\u16a6")
    testthat::expect_identical(runes::runes("tth"), "\u16cf\u16a6")
    testthat::expect_equal(runes::runes("ng"), "\u16dc")
    testthat::expect_identical(runes::runes("ng"), "\u16dc")
    testthat::expect_equal(runes::runes("nng"), "\u16be\u16dc")
    testthat::expect_identical(runes::runes("nng"), "\u16be\u16dc")
})
testthat::test_that("Character Pairs Linked To Single Rune Are Both Replaced", {
    testthat::expect_equal(runes::runes("w v"), "\u16b9 \u16b9")
    testthat::expect_identical(runes::runes("w v"), "\u16b9 \u16b9")
    testthat::expect_equal(runes::runes("c k"), "\u16b2 \u16b2")
    testthat::expect_identical(runes::runes("c k"), "\u16b2 \u16b2")
    testthat::expect_equal(runes::runes("j y"), "\u16c3 \u16c3")
    testthat::expect_identical(runes::runes("j y"), "\u16c3 \u16c3")
})

testthat::test_that("Single Character Replacement Functions Correctly", {
    testthat::expect_equal(runes::runes("a"), "\u16a8")
    testthat::expect_equal(runes::runes("b"), "\u16d2")
    testthat::expect_equal(runes::runes("d"), "\u16de")
    testthat::expect_equal(runes::runes("e"), "\u16d6")
    testthat::expect_equal(runes::runes("f"), "\u16a0")
    testthat::expect_equal(runes::runes("g"), "\u16b7")
    testthat::expect_equal(runes::runes("h"), "\u16bb")
    testthat::expect_equal(runes::runes("i"), "\u16c1")
    testthat::expect_equal(runes::runes("l"), "\u16da")
    testthat::expect_equal(runes::runes("m"), "\u16d7")
    testthat::expect_equal(runes::runes("n"), "\u16be")
    testthat::expect_equal(runes::runes("o"), "\u16df")
    testthat::expect_equal(runes::runes("p"), "\u16c8")
    testthat::expect_equal(runes::runes("r"), "\u16b1")
    testthat::expect_equal(runes::runes("s"), "\u16cb")
    testthat::expect_equal(runes::runes("t"), "\u16cf")
    testthat::expect_equal(runes::runes("u"), "\u16a2")
    testthat::expect_equal(runes::runes("z"), "\u16c9")
    testthat::expect_identical(runes::runes("a"), "\u16a8")
    testthat::expect_identical(runes::runes("b"), "\u16d2")
    testthat::expect_identical(runes::runes("d"), "\u16de")
    testthat::expect_identical(runes::runes("e"), "\u16d6")
    testthat::expect_identical(runes::runes("f"), "\u16a0")
    testthat::expect_identical(runes::runes("g"), "\u16b7")
    testthat::expect_identical(runes::runes("h"), "\u16bb")
    testthat::expect_identical(runes::runes("i"), "\u16c1")
    testthat::expect_identical(runes::runes("l"), "\u16da")
    testthat::expect_identical(runes::runes("m"), "\u16d7")
    testthat::expect_identical(runes::runes("n"), "\u16be")
    testthat::expect_identical(runes::runes("o"), "\u16df")
    testthat::expect_identical(runes::runes("p"), "\u16c8")
    testthat::expect_identical(runes::runes("r"), "\u16b1")
    testthat::expect_identical(runes::runes("s"), "\u16cb")
    testthat::expect_identical(runes::runes("t"), "\u16cf")
    testthat::expect_identical(runes::runes("u"), "\u16a2")
    testthat::expect_identical(runes::runes("z"), "\u16c9")
})
testthat::test_that("Vector of Alphabet and of Runes match", {
    testthat::expect_equal(runes::runes("a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z"),
                           c("\u16a8,\u16d2,\u16b2,\u16de,\u16d6,\u16a0,\u16b7,\u16bb,\u16c1,\u16c3,\u16b2,\u16da,\u16d7,\u16be,\u16df,\u16c8,q,\u16b1,\u16cb,\u16cf,\u16a2,\u16b9,\u16b9,x,\u16c3,\u16c9"))
})

testthat::test_that("Numbers and Special Characters Are Unaffected", {
    testthat::expect_equal(runes::runes("0123456789-_=+\\|`~,./<>?;:\'\"[]{}!@#$%^&*()"),
                           c("0123456789-_=+\\|`~,./<>?;:\'\"[]{}!@#$%^&*()"))
})

testthat::test_that("Hide options functions as intended", {
    testthat::expect_equal(runes::runes("x", hide = FALSE), "x")
    testthat::expect_equal(runes::runes("x", hide = TRUE), "")
    testthat::expect_equal(runes::runes("q", hide = FALSE), "q")
    testthat::expect_equal(runes::runes("q", hide = TRUE), "")
})

testthat::test_that("Test phrase passes through correctly", {
    testthat::expect_equal(runes::runes("Hello!", hide = FALSE), "\u16bb\u16d6\u16da\u16da\u16df!")
})
