% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dump.list.format.R
\name{dump.list.format}
\alias{dump.list.format}
\alias{dump.format}
\alias{list.format}
\title{Conversion Between a Named List and a Character String in the R Dump Format}
\usage{
dump.format(namedlist = list(), checkvalid = TRUE, convertfactors = TRUE)

list.format(data = character(), checkvalid = TRUE)
}
\arguments{
\item{namedlist}{a named list of numeric or integer (or something that can be coerced to numeric) vectors, matrices or arrays.  The name of each list item will be used as the name of the resulting dump.format variables.}

\item{checkvalid}{option to ensure that the object returned from the function does not contain any values that would be invalid for import into JAGS, such as Inf, -Inf or character values etc.}

\item{convertfactors}{option to automatically convert any factor variables to numeric (otherwise the presence of factors will create an error if checkvalid==TRUE).}

\item{data}{a character string in the R dump format, such as that produced by dump.format.}
}
\value{
Either a character string in the R dump format (for dump.format), or a named list (for list.format).
}
\description{
Convert a named list of numeric vector(s) or array(s) of data or initial values to a character string in the correct format to be read directly by JAGS as either data or initial values.
}
\details{
The 'dump.format' function creates a character string of the supplied variables in the same way that dump() would, except that the result is returned as a character string rather than written to file.  Additionally, dump.format() will look for any variable with the name '.RNG.name' and double quote the value if not already double quoted (to ensure compatibility with JAGS).
}
\examples{
# A named list:
namedlist1 <- list(N=10, Count=c(4,2,7,0,6,9,1,4,12,1))
# Convert to a character vector:
chardata <- dump.format(namedlist1)
# And back to a named list:
namedlist2 <- list.format(chardata)
# These should be the same:
stopifnot(identical(namedlist1, namedlist2))
}
\seealso{
\code{\link{run.jags}} and \code{\link[base]{dump}}
}
\keyword{methods}
