% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save-run.R
\name{save_run}
\alias{save_run}
\title{Cache result}
\usage{
save_run(code, file, timing = TRUE)
}
\arguments{
\item{code}{Code to run. Do not forget to wrap it with \code{{ }}.}

\item{file}{File path where the result is stored. Should have extension \code{rds}.}

\item{timing}{Whether to print timing of running code? Default is \code{TRUE}.}
}
\value{
The evaluation of \code{code} the first time, the content of \code{file} otherwise.
}
\description{
Cache result
}
\examples{
# Prepare some temporary file
tmp <- tempfile(fileext = ".rds")

# Run once because result does not exist yet
save_run({
  Sys.sleep(2)
  1
}, file = tmp)

# Skip run because result exists
save_run({
  Sys.sleep(2)
  1
}, file = tmp)

}
