% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cancelOrder.R
\name{cancelOrder}
\alias{cancelOrder}
\title{Cancel an order on a broker/exchange platform}
\usage{
cancelOrder(
  src = "",
  api.key = "",
  orderId = "",
  clientId = "",
  board = "",
  live = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{src}{character string, the name of the broker/exchange platform, e.g. "tinkoff", "finam", "alor"}

\item{api.key}{character string, the API key required for authentication}

\item{orderId}{character string, the ID of the order to be cancelled}

\item{clientId}{character string, the ID of the client account}

\item{board}{character string, the name of the exchange board, required for some platforms}

\item{live}{logical, whether to execute the order in a live environment, default is TRUE}

\item{verbose}{logical, whether to print the HTTP response message, default is TRUE}
}
\value{
character string, the response message from the HTTP request
}
\description{
This function cancels an existing order on a specified broker or exchange platform
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
cancelOrder(src = 'Finam',api.key = 'finam_token',orderId = 'otderID',clientId = 'your cliend id')
}
