% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_rv_bugs.R
\name{as.rv.bugs}
\alias{as.rv.bugs}
\alias{as.rvsummary.bugs}
\title{Coerce a bugs object into Random Variable Objects}
\usage{
\method{as.rv}{bugs}(x, list. = TRUE, ...)
}
\arguments{
\item{x}{a bugs (R2WinBUGS) object}

\item{list.}{logical; return a list of \code{rv} objects instead of a single
\code{rv} object (vector)?}

\item{\dots}{(ignored)}
}
\value{
If \code{list.=TRUE}, a named \emph{list} of random vectors or a
named random vector, otherwise a random vector.  (Usually one would prefer a
list.)f
}
\description{
\code{as.rv.bugs} coerces an \code{R2WinBUGS} object to a list of \code{rv}
objects or to a named rv object (vector).
}
\details{
\code{as.rvsummary.bugs} works similarly but coerces the resulting \code{rv}
objects into \code{rvsummary} objects.
}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{classes}
