% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvquantile.R
\name{rvquantile}
\alias{rvquantile}
\alias{rvquantile.rv}
\alias{rvquantile.rvsummary}
\alias{rvmedian}
\title{Componentwise Quantiles of Random Variables}
\usage{
rvquantile(x, ...)

\method{rvquantile}{rv}(x, probs = c(0.025, 0.1, 0.25, 0.5, 0.75, 0.9,
  0.975), ignoreInf = FALSE, ...)
}
\arguments{
\item{x}{an object}

\item{\dots}{further arguments passed to \code{quantile}}

\item{probs}{numeric vector of probabilities with values in \code{[0,1]}}

\item{ignoreInf}{ignore infinite values}
}
\value{
A \emph{numeric} vector of quantiles.
}
\description{
Computes componentwise quantiles of random vectors or arrays.
}
\details{
\code{rvquantile} applies the \code{quantile} function to each column of
\code{sims(x)}.

\code{rvmedian} applies \code{median} to the each column of \code{sims(x)}.
}
\examples{

  x <- rvnorm(3)
  rvquantile(x)
  rvquantile(x, probs=c(0, 0.01, 0.99, 1))
  rvmedian(x)

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{classes}
