% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvec-package.R
\docType{package}
\name{rvec-package}
\alias{rvec-package}
\title{Package 'rvec'}
\description{
Tools for working with random draws from a distribution, eg
draws from a posterior distribution in a Bayesian analysis.
}
\details{
An rvec holds multiple draws, but wherever possible
behaves like an ordinary R vector. For instance, if \code{x}
is an rvec holding 1000 draws from a distribution,
then \code{2 * x} returns a new rvec where each draw has
been multiplied by 2.

To summarise across draws, use a function starting with \code{draws}.
For instance, to calculate a credible interval, use \code{\link[=draws_ci]{draws_ci()}}.
}
\section{Functions}{


\strong{Creating rvecs}
\itemize{
\item \code{\link[=rvec]{rvec()}} - class depends on input
\item \code{\link[=rvec_dbl]{rvec_dbl()}} - doubles
\item \code{\link[=rvec_int]{rvec_int()}} - integers
\item \code{\link[=rvec_lgl]{rvec_lgl()}} - logical
\item \code{\link[=rvec_chr]{rvec_chr()}} - character
\item \code{\link[=collapse_to_rvec]{collapse_to_rvec()}} - data in data frame
}

\strong{Manipulating rvecs}
\itemize{
\item \code{\link[=if_else_rvec]{if_else_rvec()}}
\item \code{\link[=map_rvec]{map_rvec()}}
}

\strong{Probability distributions}
\itemize{
\item \code{\link[=dbeta_rvec]{dbeta_rvec()}}
\item \code{\link[=dbinom_rvec]{dbinom_rvec()}}
\item \code{\link[=dcauchy_rvec]{dcauchy_rvec()}}
\item \code{\link[=dchisq_rvec]{dchisq_rvec()}}
\item \code{\link[=dexp_rvec]{dexp_rvec()}}
\item \code{\link[=df_rvec]{df_rvec()}}
\item \code{\link[=dgamma_rvec]{dgamma_rvec()}}
\item \code{\link[=dgeom_rvec]{dgeom_rvec()}}
\item \code{\link[=dhyper_rvec]{dhyper_rvec()}}
\item \code{\link[=dlnorm_rvec]{dlnorm_rvec()}}
\item \code{\link[=dmultinom]{dmultinom()}}
\item \code{\link[=dnbinom_rvec]{dnbinom_rvec()}}
\item \code{\link[=dnorm_rvec]{dnorm_rvec()}}
\item \code{\link[=dpois_rvec]{dpois_rvec()}}
\item \code{\link[=dt_rvec]{dt_rvec()}}
\item \code{\link[=dunif_rvec]{dunif_rvec()}}
\item \code{\link[=dweibull_rvec]{dweibull_rvec()}}
}

\strong{Summarizing across draws}
\itemize{
\item \code{\link[=draws_all]{draws_all()}}
\item \code{\link[=draws_any]{draws_any()}}
\item \code{\link[=draws_median]{draws_median()}}
\item \code{\link[=draws_mean]{draws_mean()}}
\item \code{\link[=draws_mode]{draws_mode()}}
\item \code{\link[=draws_ci]{draws_ci()}}
\item \code{\link[=draws_quantile]{draws_quantile()}}
\item \code{\link[=draws_fun]{draws_fun()}}
\item \code{\link[=n_draw]{n_draw()}}
}

\strong{Coercion, classes}
\itemize{
\item \code{\link[=as_list_col]{as_list_col()}}
\item \code{\link[=expand_from_rvec]{expand_from_rvec()}}
\item \code{\link[=is_rvec]{is_rvec()}}
}

\strong{Weighted summaries}
\itemize{
\item \code{\link[=weighted_mad]{weighted_mad()}}
\item \code{\link[=weighted_mean]{weighted_mean()}}
\item \code{\link[=weighted_median]{weighted_median()}}
\item \code{\link[=weighted_sd]{weighted_sd()}}
\item \code{\link[=weighted_var]{weighted_var()}}
}

\strong{Datasets}
\itemize{
\item \code{\link[=divorce]{divorce()}}
\item \code{\link[=reg_post]{reg_post()}}
}
}

\section{Packages with similar functionality}{

\itemize{
\item \href{https://CRAN.R-project.org/package=rv}{rv}
\item \href{https://CRAN.R-project.org/package=posterior}{posterior}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://bayesiandemography.github.io/rvec/}
  \item \url{https://github.com/bayesiandemography/rvec}
  \item Report bugs at \url{https://github.com/bayesiandemography/rvec/issues}
}

}
\author{
\strong{Maintainer}: John Bryant \email{john@bayesiandemography.com}

Other contributors:
\itemize{
  \item Bayesian Demography Limited [copyright holder]
}

}
