% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traitsearch.R
\name{traitsearch}
\alias{traitsearch}
\title{Trait focused search}
\usage{
traitsearch(taxon = NULL, has_mass = FALSE, has_length = FALSE,
  has_sex = FALSE, has_lifestage = FALSE, length_type = NULL,
  length = NULL, mass = NULL, limit = 1000, compact = TRUE,
  messages = TRUE, callopts = list(), ...)
}
\arguments{
\item{taxon}{(character) Taxonomic identifier or other text to search for}

\item{has_mass}{(logical) limit to records that have mass data (stored in 
\code{massing}). Default: \code{FALSE}}

\item{has_length}{(logical) limit to records that have length data (stored 
in \code{lengthinmm}). Default: \code{FALSE}}

\item{has_sex}{(logical) limit to records that have sex data (stored in 
\code{sex}). Default: \code{FALSE}}

\item{has_lifestage}{(logical) limit to records that have lifestage data
(stored in \code{lifestage}). Default: \code{FALSE}}

\item{length_type}{(character) length type, one of 'total length', 
'standard length', 'snout-vent length', 'head-body length', 'fork length', 
'total length range', 'standard length range', 'snout-vent length range',
'head-body length range', 'fork length range'. (stored in \code{lengthtype}) 
Default: \code{NULL}}

\item{length}{(list) list of query terms for length, e.g., "< 100"}

\item{mass}{(list) list of query terms for mass, e.g., "< 100"}

\item{limit}{(numeric) Limit on the number of records returned. If >1000 
results, we use a cursor internally, but you should still get up to the 
results you asked for. See also 
\code{\link{bigsearch}} to get larger result sets in a text file via email.}

\item{compact}{Return a compact data frame (boolean)}

\item{messages}{Print progress and information messages. Default: TRUE}

\item{callopts}{curl options in a list passed on to 
\code{\link[crul]{HttpClient}}, see examples}

\item{...}{(character) Additional search terms. These must be unnamed}
}
\value{
a list, same as returned by \code{\link{vertsearch}}, with data
in the \code{data} slot
}
\description{
Trait focused search
}
\details{
Wraps \code{\link{vertsearch}}, with some of the same parameters,
but with additional parameters added to make querying for traits easy.
}
\examples{
traitsearch(has_mass = TRUE, limit = 3)

\dontrun{
traitsearch(has_lifestage = TRUE)
traitsearch(has_mass = TRUE, has_length = TRUE)
res <- traitsearch(length_type = "total length", 
  length = list(">= 300", "<= 1000"))
summary(as.numeric(res$data$lengthinmm))
res <- traitsearch(has_mass = TRUE, mass = list(">= 20", "<= 500"))
summary(as.numeric(res$data$massing))

traitsearch(taxon = "aves", has_mass = TRUE, limit = 100)

# curl options
traitsearch(has_mass = TRUE, limit = 10, callopts = list(verbose = TRUE))
}
}
