% Generated by roxygen2 (4.0.2): do not edit by hand
\name{html_text}
\alias{html_attr}
\alias{html_attrs}
\alias{html_tag}
\alias{html_text}
\title{Extract attributes, text and tag name from html.}
\usage{
html_text(x, ...)

html_tag(x)

html_attrs(x)

html_attr(x, name, default = NA_character_)
}
\arguments{
\item{x}{Either a complete document (HTMLInternalDocument),
a list of tags (XMLNodeSet) or a single tag (XMLInternalElementNode).}

\item{...}{Other arguments passed onto \code{\link[XML]{xmlValue}()}.
The most useful argument is \code{trim = TRUE} which will remove leading
and trailing whitespace.}

\item{name}{Name of attribute to extract.}

\item{default}{A string used as a default value when the attribute does
not exist in every node.}
}
\value{
\code{html_attr}, \code{html_tag} and \code{html_text}, a character
  vector; \code{html_attrs}, a list.
}
\description{
Extract attributes, text and tag name from html.
}
\examples{
movie <- html("http://www.imdb.com/title/tt1490017/")
cast <- html_nodes(movie, "#titleCast span.itemprop")
html_text(cast)
html_tag(cast)
html_attrs(cast)
html_attr(cast, "class")
html_attr(cast, "itemprop")

basic <- html("<p class='a'><b>Bold text</b></p>")
p <- html_node(basic, "p")
p
# Can subset with numbers to extract children
p[[1]]
# Use html_attr to get attributes
html_attr(p, "class")
}

