% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vinecop_methods.R
\name{vinecop_distributions}
\alias{vinecop_distributions}
\alias{dvinecop}
\alias{pvinecop}
\alias{rvinecop}
\alias{dvinecop_dist}
\alias{pvinecop_dist}
\alias{rvinecop_dist}
\title{Vine copula distributions}
\usage{
dvinecop(u, vinecop, cores = 1)

pvinecop(u, vinecop, n_mc = 10^4, cores = 1)

rvinecop(n, vinecop, qrng = FALSE, cores = 1)
}
\arguments{
\item{u}{evaluation points, either a length d vector or a d-column matrix,
where d is the number of variables in the vine.}

\item{vinecop}{an object of class \code{"vinecop_dist"}.}

\item{cores}{number of cores to use; if larger than one, computations are
done in parallel on \code{cores} batches .}

\item{n_mc}{number of samples used for quasi Monte Carlo integration.}

\item{n}{number of observations.}

\item{qrng}{if \code{TRUE}, generates quasi-random numbers using the multivariate
Generalized Halton sequence up to dimension 300 and the Generalized Sobol
sequence in higher dimensions (default \code{qrng = FALSE}).}
}
\value{
\code{dvinecop()} gives the density, \code{pvinecop()} gives the distribution function,
and \code{rvinecop()} generates random deviates.

The length of the result is determined by \code{n} for \code{rvinecop()}, and
the number of rows in \code{u} for the other functions.

The \code{vinecop} object is recycled to the length of the
result.
}
\description{
Density, distribution function and random generation
for the vine copula distribution.
}
\details{
See \link{vinecop} for the estimation and construction of vine copula models.
Here, the density, distribution function and random generation
for the vine copulas are standard.
}
\examples{
# specify pair-copulas
bicop <- bicop_dist("bb1", 90, c(3, 2))
pcs <- list(
  list(bicop, bicop), # pair-copulas in first tree
  list(bicop) # pair-copulas in second tree
)

# specify R-vine matrix
mat <- matrix(c(1, 2, 3, 1, 2, 0, 1, 0, 0), 3, 3)

# set up vine copula model
vc <- vinecop_dist(pcs, mat)

# simulate from the model
u <- rvinecop(200, vc)
pairs(u)

# evaluate the density and cdf
dvinecop(u[1, ], vc)
pvinecop(u[1, ], vc)
}
