% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bicop_methods.R
\name{bicop_distributions}
\alias{bicop_distributions}
\alias{dbicop}
\alias{pbicop}
\alias{rbicop}
\alias{hbicop}
\alias{dbicop_dist}
\alias{pbicop_dist}
\alias{rbicop_dist}
\alias{hbicop_dist}
\title{Bivariate copula distributions}
\usage{
dbicop(u, family, rotation, parameters, var_types = c("c", "c"))

pbicop(u, family, rotation, parameters, var_types = c("c", "c"))

rbicop(n, family, rotation, parameters, qrng = FALSE)

hbicop(
  u,
  cond_var,
  family,
  rotation,
  parameters,
  inverse = FALSE,
  var_types = c("c", "c")
)
}
\arguments{
\item{u}{evaluation points, a matrix with at least two columns, see
\emph{Details}.}

\item{family}{the copula family, a string containing the family name (see
\code{\link{bicop}} for all possible families).}

\item{rotation}{the rotation of the copula, one of \code{0}, \code{90}, \code{180}, \code{270}.}

\item{parameters}{a vector or matrix of copula parameters.}

\item{var_types}{variable types, a length 2 vector; e.g., \code{c("c", "c")} for
both continuous (default), or \code{c("c", "d")} for first variable continuous
and second discrete.}

\item{n}{number of observations. If `length(n) > 1``, the length is taken to
be the number required.}

\item{qrng}{if \code{TRUE}, generates quasi-random numbers using the bivariate
Generalized Halton sequence (default \code{qrng = FALSE}).}

\item{cond_var}{either \code{1} or \code{2}; \code{cond_var = 1} conditions on the first
variable, \code{cond_var = 2} on the second.}

\item{inverse}{whether to compute the h-function or its inverse.}
}
\value{
\code{dbicop()} gives the density, \code{pbicop()} gives the distribution function,
\code{rbicop()} generates random deviates, and \code{hbicop()} gives the h-functions
(and their inverses).

The length of the result is determined by \code{n} for \code{rbicop()}, and
the number of rows in \code{u} for the other functions.

The numerical arguments other than \code{n} are recycled to the length of the
result.
}
\description{
Density, distribution function, random generation and h-functions (with their
inverses) for the bivariate copula distribution.
}
\details{
See \link{bicop} for the various implemented copula families.

The copula density is defined as joint density divided by marginal
densities, irrespective of variable types.

H-functions (\code{hbicop()}) are conditional distributions derived
from a copula. If \eqn{C(u, v) = P(U \le u, V \le v)} is a copula, then
\deqn{h_1(u, v) = P(V \le v | U = u) = \partial C(u, v) / \partial u,}
\deqn{h_2(u, v) = P(U \le u | V = v) = \partial C(u, v) / \partial v.}
In other words, the H-function number refers to the conditioning variable.
When inverting H-functions, the inverse is then taken with respect to the
other variable, that is \code{v} when \code{cond_var = 1} and \code{u} when \code{cond_var = 2}.
\subsection{Discrete variables}{

When at least one variable is discrete, more than two columns are required
for \code{u}: the first \eqn{n \times 2} block contains realizations of
\eqn{F_{X_1}(x_1), F_{X_2}(x_2)}. The second \eqn{n \times 2} block contains
realizations of \eqn{F_{X_1}(x_1^-), F_{X_2}(x_2^-)}. The minus indicates a
left-sided limit of the cdf. For, e.g., an integer-valued variable, it holds
\eqn{F_{X_1}(x_1^-) = F_{X_1}(x_1 - 1)}. For continuous variables the left
limit and the cdf itself coincide. Respective columns can be omitted in the
second block.
}
}
\note{
The functions can optionally be used with a \link{bicop_dist} object in place
of the \code{family} argument, e.g.,
\code{dbicop(c(0.1, 0.5), bicop_dist("indep"))} or
\code{hbicop(c(0.1, 0.5), 2, bicop_dist("indep"))}.
}
\examples{
## evaluate the copula density
dbicop(c(0.1, 0.2), "clay", 90, 3)
dbicop(c(0.1, 0.2), bicop_dist("clay", 90, 3))

## evaluate the copula cdf
pbicop(c(0.1, 0.2), "clay", 90, 3)

## simulate data
plot(rbicop(500, "clay", 90, 3))

## h-functions
joe_cop <- bicop_dist("joe", 0, 3)
# h_1(0.1, 0.2)
hbicop(c(0.1, 0.2), 1, "bb8", 0, c(2, 0.5))
# h_2^{-1}(0.1, 0.2)
hbicop(c(0.1, 0.2), 2, joe_cop, inverse = TRUE)

## mixed discrete and continuous data
x <- cbind(rpois(10, 1), rnorm(10, 1))
u <- cbind(ppois(x[, 1], 1), pnorm(x[, 2]), ppois(x[, 1] - 1, 1))
pbicop(u, "clay", 90, 3, var_types = c("d", "c"))

}
\seealso{
\code{\link[=bicop_dist]{bicop_dist()}}, \code{\link[=bicop]{bicop()}}
}
