% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussfit.R
\name{Gaussfit}
\alias{Gaussfit}
\title{Fit Gaussians to Absorption Features of a Normalized Spectrum}
\usage{
Gaussfit(wvl, flx, ftrs, cores = 1, mse_max1 = 0.00014, mse_max2 = 1e-04)
}
\arguments{
\item{wvl}{vector of wavelengths of the spectrum}

\item{flx}{vector of normalized flux of the spectrum}

\item{ftrs}{a list of length 2 vectors that each give the lower and upper bounds of found absorption features. The \code{wvbounds} component of the \code{findabsorptionfeatures} function output is designed to be this.}

\item{cores}{the integer count of cores to parallelize over. If set to 1, no parallelization is done.}

\item{mse_max1}{the maximum mean squared error required for a fit from one Gaussian to be considered a good fit for an absorption feature}

\item{mse_max2}{the maximum mean squared error required for a fit of two Gaussians to be considered a good fit for an absorption feature}
}
\value{
a list with the following components:
\item{parameters}{a dataframe with the wavelength bounds, fitted amplitude,
fitted center, fitted spread, and fit type for absorption features with a
good fit. A fit type of 0 indicates that the feature had a good fit of a single
Gaussian. A fit type of 1 indicates that the feature did not have a good fit
with a single Gaussian initially, but after fitting with two it did.}
\item{fitted}{the vector of fitted values (with the same length as the
\code{wvl} parameter) using only the features that produced a good fit.}
\item{goodfits}{a vector of the indices for which rows in the \code{ftrs}
parameter were well fitted with either 1 or 2 Gaussians at the end}
\item{mse}{a vector with the mean squared error for each of the features in
the \code{ftrs} parameter using the final fitted values}
}
\description{
This function takes a spectrum, which ideally is a high signal-to-noise template
spectrum estimated with the \code{estimate_template} function, and the
absorption features found with the \code{findabsorptionfeatures} function
and uses nonlinear least-squares to fit Gaussians to the features. This follows
the procedure described in \href{https://arxiv.org/abs/2005.14083}{Holzer et al. (2020)}.
}
\examples{
data(template)
ftrs = findabsorptionfeatures(template$Wavelength,
                              template$Flux,
                              pix_range = 8, gamma = 0.05,
                              alpha = 0.07, minlinedepth = 0.015)
gapp = Gaussfit(template$Wavelength, template$Flux, ftrs)
plot(template$Wavelength, template$Flux)
lines(template$Wavelength, gapp$fitted, col=2)

}
