% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrape.R
\name{walk_melb}
\alias{walk_melb}
\title{API to Melbourne pedestrian data using R}
\usage{
walk_melb(from = to - 6L, to = Sys.Date() - 1L, tz = "")
}
\arguments{
\item{from}{Starting date.}

\item{to}{Ending date.}

\item{tz}{Time zone.}
}
\value{
A data frame including "Sensor", "Date_Time", "Date", "Time",
"Count" variables.
}
\description{
API to Melbourne pedestrian data using R
}
\details{
The data is sourced from \href{https://data.melbourne.vic.gov.au/Transport-Movement/Pedestrian-volume-updated-monthly-/b2ak-trbp}{Melbourne Open Data Portal}.
At its heart, this function scrapes the data through the
"https://compedapi.herokuapp.com" api. A progress bar shows the download
status. Please refer to Melbourne Open Data Portal for more details about
the dataset and its policy.
}
\examples{
\dontrun{
  ped_df <- walk_melb()
  head(ped_df)
}
}
