% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/rwirelesscom.R
\name{eyediagram}
\alias{eyediagram}
\title{Eye Diagram}
\usage{
eyediagram(x, Ns = 1, Np = 3, No = 1, iq = "r", pch = 19, cex = 0.1,
  ...)
}
\arguments{
\item{x}{- vector of real or complex points}

\item{Ns}{- number of samples per symbol period}

\item{Np}{- number of symbol periods to plot along the horizontal axis}

\item{No}{- offset (n points) alignment of the eyediagram along the horizontal asis}

\item{iq}{- parameter indicates whether to plot the in-phase Re(x) (iq="r" default) or quadrature Im(x) (iq="q")}

\item{pch}{- Graphical parameter pch (plotting character) set to 19 by default ("point")}

\item{cex}{- Graphical parameter cex magnificaiton of plotting symbols relative to 1 default set to 0.1.}

\item{...}{- graphical environment parameters are input to eyediagram}
}
\description{
Receives a vector x of real or complex points and plots the Re or Im part of x in the form of an "eyediagram."
The symbol period is indicated by the input Ns (samples per symbol) and horizontal sweep Np indicates
the the number of symbol periods to plot along the horizontal access. The eyediagram
is useful for evaluating inter-symbol interference associated with the in-phase or quadrature part
of a modulated signal.
}
\examples{
# Step 1: generate random set of bits
M=4
Nsymbols=10000
Nbits=log2(M)*Nsymbols
bits <- sample(0:1,Nbits, replace=TRUE)

# Step 2: Generate a BPSK modulated signal including raised cosine
#  pulse shaping sampled at 64 samples per symbol period and roll-off
#  factor of 0.5.
Ns=64
B=0.5
hx=seq(-4*Ns,4*Ns,by=1)
h=rcosine(hx,B,Ns)
s <- fqpskmod(bits,Ns,h)

# Step 3: Plot the transmitted waveform with the eyediagram function.
#    Remove the initial 1000 and tail points for a cleaner diagram, i.e.
#    without startup and tail artifacts
Np=3
No=27

# real part (in-phase)
eyediagram(s[1000:60000],Ns,Np,No,iq="r",xlab="Ts",ylab="I")
# imaginary part (quadrature)
eyediagram(s[1000:60000],Ns,Np,No,iq="q",xlab="Ts",ylab="Q")
}
\seealso{
Other rwirelesscom functions: \code{\link{f16pskdemod}};
  \code{\link{f16pskmod}}; \code{\link{f16qamdemod}};
  \code{\link{f16qammod}}; \code{\link{f64qamdemod}};
  \code{\link{f64qammod}}; \code{\link{f8pskdemod}};
  \code{\link{f8pskmod}}; \code{\link{fNo}};
  \code{\link{fbpskdemod}}; \code{\link{fbpskmod}};
  \code{\link{fqpskdemod}}; \code{\link{iqdensityplot}};
  \code{\link{iqscatterplot}}; \code{\link{stemplot}}
}

