% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_conda_yml.R
\name{construct_conda_yml}
\alias{construct_conda_yml}
\title{Construct a conda yaml}
\usage{
construct_conda_yml(
  name = "test",
  channels = list("conda-forge", "nodefaults"),
  dependencies = list(),
  pip = NULL,
  save_path = here::here(paste0(name, "_conda.yml")),
  return_path = TRUE,
  preview = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{name}{Name of \code{conda} env.}

\item{channels}{\code{conda} channels to use.}

\item{dependencies}{Packages to install via \code{conda}.}

\item{pip}{Packages to install via \code{pip}.}

\item{save_path}{Path to save the yaml file to.}

\item{return_path}{Return the path to the saved \emph{yaml} workflow file
(default: \code{TRUE}), or return the \emph{yaml} object directly.}

\item{preview}{Print the yaml file to the R console.}

\item{verbose}{Print messages.}
}
\value{
description

Path or yaml object.
}
\description{
Construct a yaml file to be used for building a given \code{conda} 
environment.
}
\examples{
yml <- construct_conda_yml(name="myenv",
                           dependencies=c("anndata","scanpy"),
                           return_path = FALSE,  
                           ## Writing to temp only for example
                           save_path=tempfile(fileext="myenv_conda.yml"))
}
