% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeplot.pseudo.ess.R
\name{makeplot.pseudo.ess}
\alias{makeplot.pseudo.ess}
\title{Plot the pseudo ESS of tree topologies from MCMC chains.}
\usage{
makeplot.pseudo.ess(chains, burnin = 0, n = 20)
}
\arguments{
\item{chains}{A list of rwty.trees objects.}

\item{burnin}{The number of trees to eliminate as burnin}

\item{n}{The number of replicate analyses to do}
}
\value{
pseudo.ess.plot A ggplot2 plot object, in which each chain is represented by a point
which represents the median pseudo ESS from the n replicates, and
whiskers representing the upper and lower 95% intervals of the n replicates.
}
\description{
This function takes a list of rwty.trees objects, and plots the
pseudo ESS of the tree topologies from each chain, after removing burnin. 
Each caulcation is repeated n times, where in each replicate a random
tree from the chain is chosen as a 'focal' tree. The calculation works
by calculating the path distance of each tree in the chain
from the focal tree, and calculating the ESS of the resulting vector
of phylogenetic distances using the effectiveSize function from the 
coda package. NB this function requires the calculation of many
tree distances, so can take some time.
}
\examples{
\dontrun{
data(fungus)
makeplot.pseudo.ess(fungus, burnin = 20, n = 10)
}
}
\keyword{ESS,}
\keyword{distance}
\keyword{path}

