% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.autocorr.m.R
\name{estimate.autocorr.m}
\alias{estimate.autocorr.m}
\title{Calculate sampling interval based on exponential semivariogram model.}
\usage{
estimate.autocorr.m(dat, ac.cutoff = 0.95)
}
\arguments{
\item{dat}{A data frame output from topological.autocorr.}

\item{ac.cutoff}{Default 0.95. The proportion of the asymptotic topological distance to use as a cutoff for determining sampling interval. For example, if ac.cutoff = 0.9, then the minimum sampling interval returned is the one that guarantees a topological distance at least 0.9 times the asymptotic value.}
}
\value{
A data frame consisting of the value matching the ac.cutoff proportion of the asymptotic 
topological distance for each chain.  This sampling interval estimates the interval at which topological distances
are no longer autocorrelated. If the value is larger than the largest sampling distance, the table records this as a value of -1
}
\description{
This function uses an exponential semivariogram model to estimate the asymptotic topological distance, and
uses that to estimate the sampling interval at which topological distances have reached some fixed
proportion of that value (default 0.95).  It expects as input a data table output by rwty's topological.autocorr function
}
\examples{
data(fungus)
\dontrun{
# To get a good estimate we need all sampling intervals
autocorr.intervals = as.integer(length(fungus[[1]]$trees)/21)
sampling.table <- topological.autocorr(fungus, burnin = 20, autocorr.intervals = autocorr.intervals)
estimate.autocorr.m(sampling.table)
}
}
\keyword{autocorrelation,}
\keyword{distance}
\keyword{path}
