% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slide.freq.R
\name{slide.freq}
\alias{slide.freq}
\title{Sliding window measurements of clade split frequencies.}
\usage{
slide.freq(chains, burnin = 0, window.size = 20)
}
\arguments{
\item{chains}{A list of rwty.chain objects.}

\item{burnin}{The number of trees to eliminate as burnin. Defaults to zero.}

\item{window.size}{The number of trees to include in each window (note, specified as a number of sampled trees, not a number of generations)}
}
\value{
A list of rwty.slide objects, one per chain in the input list of chains.
Each rwty.slide object contains the frequencies of clades in the sliding
windows, and a translation table that converts clade groupings to factors.
}
\description{
This function takes sliding windows of a specified length over an MCMC chain
and calculates the split frequency of clades within that window.  It
allows users to see whether the chain is visiting different areas of treespace.
}
\examples{
\dontrun{
data(fungus)
slide.data <- slide.freq(fungus, burnin=20)\\
}
}
\keyword{MCMC,}
\keyword{convergence}
\keyword{frequency,}
\keyword{split}
