% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llik.R
\name{llikNbinomMu}
\alias{llikNbinomMu}
\title{Calculate the log likelihood of the negative binomial function (and its derivatives)}
\usage{
llikNbinomMu(x, size, mu, full = FALSE)
}
\arguments{
\item{x}{Number of successes}

\item{size}{Size of trial}

\item{mu}{mu parameter for negative binomial}

\item{full}{Add the data frame showing x, mean, sd as well as the
fx and derivatives}
}
\value{
data frame with \code{fx} for the pdf value of with
\code{dProb} that has the derivatives with respect to the parameters at
the observation time-point
}
\description{
Calculate the log likelihood of the negative binomial function (and its derivatives)
}
\details{
In an \code{rxode2()} model, you can use \code{llikNbinomMu()} but you have to
use all arguments.  You can also get the derivative of \code{mu} with
\code{llikNbinomMuDmu()}
}
\examples{
\donttest{
llikNbinomMu(46:54, 100, 40)

llikNbinomMu(46:54, 100, 40, TRUE)

et <- et(46:54)
et$size <- 100
et$mu <- 40

model <- rxode2({
  fx <- llikNbinomMu(time, size, mu)
  dProb <- llikNbinomMuDmu(time, size, mu)
})

rxSolve(model, et)
}
}
\author{
Matthew L. Fidler
}
