% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llik.R
\name{llikBeta}
\alias{llikBeta}
\title{Calculate the log likelihood of the binomial function (and its derivatives)}
\usage{
llikBeta(x, shape1, shape2, full = FALSE)
}
\arguments{
\item{x}{Observation}

\item{shape1, shape2}{non-negative parameters of the Beta distribution.}

\item{full}{Add the data frame showing x, mean, sd as well as the
fx and derivatives}
}
\value{
data frame with \code{fx} for the log pdf value of with
\code{dShape1} and \code{dShape2} that has the derivatives with respect to the parameters at
the observation time-point
}
\description{
Calculate the log likelihood of the binomial function (and its derivatives)
}
\details{
In an \code{rxode2()} model, you can use \code{llikBeta()} but you have to
use all arguments.  You can also get the derivative of \code{shape1} and \code{shape2} with
\code{llikBetaDshape1()} and \code{llikBetaDshape2()}.
}
\examples{

\donttest{

x <- seq(1e-4, 1 - 1e-4, length.out = 21)

llikBeta(x, 0.5, 0.5)

llikBeta(x, 1, 3, TRUE)

et <- et(seq(1e-4, 1-1e-4, length.out=21))
et$shape1 <- 0.5
et$shape2 <- 1.5

model <- rxode2({
  fx <- llikBeta(time, shape1, shape2)
  dShape1 <- llikBetaDshape1(time, shape1, shape2)
  dShape2 <- llikBetaDshape2(time, shape1, shape2)
})

rxSolve(model, et)
}
}
\author{
Matthew L. Fidler
}
