% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_xyData.R
\name{read_xyData}
\alias{read_xyData}
\title{Import xy-Data for Supported Formats into R}
\usage{
read_xyData(file, options = "", verbose = TRUE)
}
\arguments{
\item{file}{\link{character} (\strong{required}): path and file to be imported. The argument accepts an \code{URL}.}

\item{options}{\link{character} (with default): set format options (see \link{rxylib-package})}

\item{verbose}{\link{logical} (\emph{with default}): enables/disables verbose mode}
}
\value{
The functions returns a \link{list} of matrices.
}
\description{
The function provides access to the underlying \code{xylib} to import data for supported file formats
into R. In most cases, only the file path is needed with further arguments to import the data.
The function automatically recognises allowed formats. See \link{rxylib-package} for supported formats.
}
\section{Function version}{
 0.1.1
}

\examples{

##load example dataset
file <- system.file("extdata/ExampleSpectrum.CNF", package = "rxylib")
results <- read_xyData(file)

##plot spectrum
plot(results[[1]],
 type = "l",
 log = "y",
 xlab = "Energy [keV]",
 ylab = "Counts",
 main = "Thorite - 1800 s")

mtext(side = 3, "Canberra Inspector 1000, 3 x 3 NaI probe")


}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne (France)
}
\keyword{IO}
