% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictGLM.R
\name{predictGLM}
\alias{predictGLM}
\title{Predictions for Generalized Linear Models}
\usage{
predictGLM(object, newdata, type = "link", cilevel = 0.95, quasit = FALSE, ...)
}
\arguments{
\item{object}{a \code{glm} object, i.e. the output from \code{\link{glm}}.}

\item{newdata}{prediction data frame.}

\item{type}{\code{"link"} (default) or \code{"response"} for CI on linear predictor or response scale.}

\item{cilevel}{confidence level of the interval.}

\item{quasit}{if \code{TRUE}, t multiplier for CI rather than normal multiplier in the case of a quasi model.}

\item{\dots}{optional arguments that are passed to the generic \code{predict}.}
}
\value{
A data frame with three columns: \describe{ \item{Predicted}{the
predicted count.} \item{Conf.lower}{the lower bound of the predicted count.}
\item{Conf.upper}{the upper bound of the predicted count.} }
}
\description{
An alternative to \code{\link{predictCount}} to handle Binomial as well as
Poisson models
}
\details{
Note: The data frame, newdata, must have the same column order and data
types (e.g. numeric or factor) as those used in fitting the model.
}
\seealso{
\code{\link{predict}}, \code{\link{predict.glm}}, \code{\link{as.data.frame}}.
}
\keyword{htest}
