% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotClim.R
\name{PlotClim}
\alias{PlotClim}
\title{Plots Climatologies}
\usage{
PlotClim(exp_clim, obs_clim = NULL, toptitle = "", ytitle = "",
  monini = 1, freq = 12, limits = NULL, listexp = c("exp1", "exp2",
  "exp3"), listobs = c("obs1", "obs2", "obs3"), biglab = FALSE,
  leg = TRUE, sizetit = 1, fileout = NULL, width = 8, height = 5,
  size_units = "in", res = 100, ...)
}
\arguments{
\item{exp_clim}{Matrix containing the experimental data with dimensions:\cr
c(nmod/nexp, nmemb/nparam, nltime) or c(nmod/nexp, nltime)}

\item{obs_clim}{Matrix containing the observational data (optional) with 
dimensions:\cr
c(nobs, nmemb, nltime) or c(nobs, nltime)}

\item{toptitle}{Main title, optional.}

\item{ytitle}{Title of Y-axis, optional.}

\item{monini}{Starting month between 1 and 12. Default = 1.}

\item{freq}{1 = yearly, 12 = monthly, 4 = seasonal, ... Default = 12.}

\item{limits}{c(lower limit, upper limit): limits of the Y-axis, optional.}

\item{listexp}{List of experiment names, optional.}

\item{listobs}{List of observational dataset names, optional.}

\item{biglab}{TRUE/FALSE for presentation/paper plot. Default = FALSE.}

\item{leg}{TRUE/FALSE to plot the legend or not.}

\item{sizetit}{Multiplicative factor to scale title size, optional.}

\item{fileout}{Name of output file. Extensions allowed: eps/ps, jpeg, png, 
pdf, bmp and tiff. The default value is NULL, which the figure is shown
in a pop-up window.}

\item{width}{File width, in the units specified in the parameter size_units 
(inches by default). Takes 8 by default.}

\item{height}{File height, in the units specified in the parameter 
size_units (inches by default). Takes 5 by default.}

\item{size_units}{Units of the size of the device (file or window) to plot 
in. Inches ('in') by default. See ?Devices and the creator function of the 
corresponding device.}

\item{res}{Resolution of the device (file or window) to plot in. See 
?Devices and the creator function of the corresponding device.}

\item{...}{Arguments to be passed to the method. Only accepts the following
graphical parameters:\cr
adj ann ask bg bty cex.sub cin col.axis col.lab col.main col.sub cra crt 
csi cxy err family fg fig font font.axis font.lab font.main font.sub lend 
lheight ljoin lmitre mar mex mfcol mfrow mfg mkh oma omd omi page pch plt 
smo srt tck usr xaxp xaxs xaxt xlog xpd yaxp yaxs yaxt ylbias ylog \cr
For more information about the parameters see `par`.}
}
\description{
Plots climatologies as a function of the forecast time for any index output 
from \code{Clim()} and organized in matrix with dimensions:\cr
c(nmod/nexp, nmemb/nparam, nltime) or c(nmod/nexp, nltime) for the 
experiment data\cr
c(nobs, nmemb, nltime) or c(nobs, nltime) for the observational data
}
\examples{
# Load sample data as in Load() example:
example(Load)
clim <- Clim(sampleData$mod, sampleData$obs)
PlotClim(clim$clim_exp, clim$clim_obs, toptitle = paste('climatologies'), 
        ytitle = 'K', monini = 11, listexp = c('CMIP5 IC3'), 
        listobs = c('ERSST'), biglab = FALSE, fileout = NULL)

}

