% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Trend.R
\name{Trend}
\alias{Trend}
\alias{.Trend}
\title{Computes the Trend of the Ensemble Mean}
\usage{
Trend(var, posTR = 2, interval = 1, siglev = 0.95, conf = TRUE)

.Trend(exp, interval = 1, siglev = 0.95, conf = TRUE)
}
\arguments{
\item{var}{An array of any number of dimensions up to 10.}

\item{posTR}{An integer indicating the position along which to compute the 
trend.}

\item{interval}{A number of months/years between 2 points along posTR 
dimension. Set 1 as default.}

\item{siglev}{A numeric value indicating the confidence level for the 
computation of confidence interval. Set 0.95 as default.}

\item{conf}{A logical value indicating whether to compute the confidence 
levels or not. Set TRUE as default.}

\item{exp}{An M by N matrix representing M forecasts from N ensemble members.}
}
\value{
\item{$trend}{
 The intercept and slope coefficients for the least squares fitting of the 
 trend. 
 An array with same dimensions as parameter 'var' except along the posTR 
 dimension, which is replaced by a length 4 (or length 2 if conf = FALSE) 
 dimension, corresponding to the lower limit of the confidence interval 
 (only present if conf = TRUE), the slope, the upper limit of the confidence 
 interval (only present if conf = TRUE), and the intercept.
}
\item{$detrended}{
 Same dimensions as var with linearly detrended var along the posTR 
 dimension.
}
Only in .Trend:
\item{$conf.int}{
 Corresponding to the limits of the \code{siglev}\% confidence interval 
 (only present if \code{conf = TRUE}) for the slope coefficient.
}
}
\description{
Computes the trend along the forecast time of the ensemble mean by least 
square fitting, and the associated error interval.\cr
Trend() also provides the time series of the detrended ensemble mean 
forecasts.\cr
The confidence interval relies on a student-T distribution.\cr\cr
.Trend provides the same functionality but taking a matrix ensemble members 
as input (exp).
}
\examples{
# Load sample data as in Load() example:
example(Load)
months_between_startdates <- 60
trend <- Trend(sampleData$obs, 3, months_between_startdates)
 \donttest{
PlotVsLTime(trend$trend, toptitle = "trend", ytitle = "K / (5 year)",
           monini = 11, limits = c(-1,1), listexp = c('CMIP5 IC3'),
           listobs = c('ERSST'), biglab = FALSE, hlines = 0,
           fileout = 'tos_obs_trend.eps')
PlotAno(trend$detrended, NULL, startDates, 
       toptitle = 'detrended anomalies (along the startdates)', ytitle = 'K',
       legends = 'ERSST', biglab = FALSE, fileout = 'tos_detrended_obs.eps')
 }

}
\author{
History:\cr
0.1  -  2011-05  (V. Guemas, \email{virginie.guemas@ic3.cat})  -  Original code\cr
1.0  -  2013-09  (N. Manubens, \email{nicolau.manubens@ic3.cat})  -  Formatting to CRAN\cr
2.0  -  2017-02  (A. Hunter, \email{alasdair.hunter@bsc.es})  -  Adapt to veriApply()
}
\keyword{datagen}
