% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Filter.R
\name{Filter}
\alias{Filter}
\title{Filter Frequency Peaks From An Array}
\usage{
Filter(xdata, freq)
}
\arguments{
\item{xdata}{Array to be filtered.}

\item{freq}{Frequency to filter.}
}
\value{
Filtered Array.
}
\description{
This function filters out the selected frequency from a time series.\cr 
The filtering is performed by dichotomy, seeking for a frequency around 
the parameter \code{freq} and the phase that maximizes the signal to subtract 
from the time series.\cr
The maximization of the signal to subtract relies on a minimization of the 
mean square differences between the time series (xdata) and the cosine of 
the specified frequency and phase.
}
\examples{
# Load sample data as in Load() example:
example(Load)
ensmod <- Mean1Dim(sampleData$mod, 2)
for (jstartdate in 1:3) {
 spectrum <- Spectrum(ensmod[1, jstartdate, ])
 for (jlen in 1:dim(spectrum)[1]) {
   if (spectrum[jlen, 2] > spectrum[jlen, 4]) {
     ensmod[1, jstartdate, ] <- Filter(ensmod[1, jstartdate, ], 
                                       spectrum[jlen, 1])
   }
 }
}
 \donttest{
PlotAno(InsertDim(ensmod, 2, 1), sdates = startDates, fileout =
       'filtered_ensemble_mean.eps') 
 }

}
\author{
History:\cr
0.1  -  2012-02  (V. Guemas, \email{virginie.guemas@bsc.es})  -  Original code\cr
1.0  -  2012-02  (N. Manubens, \email{nicolau.manubens@bsc.es})  -  Formatting to CRAN
}
\keyword{datagen}
