\name{PlotBoxWhisker}
\alias{PlotBoxWhisker}
\title{
Box-And-Whisker Plot of Time Series with Ensemble Distribution
}
\description{
Produce time series of box-and-whisker plot showing the distribution of the 
members of a forecast vs. the observed evolution. The correlation between
forecast and observational data is calculated and displayed. Only works for 
n-monthly to n-yearly time series. 
}
\usage{
PlotBoxWhisker(exp, obs, toptitle = '', ytitle = '', monini = 1, yearini = 0, 
               freq = 1, expname = "exp 1", obsname = "obs 1", drawleg = TRUE,
               fileout = "output_PlotBoxWhisker.ps",
               width = 8, height = 5, size_units = 'in', res = 100, ...) 
}
\arguments{
  \item{exp}{
Forecast array of multi-member time series, e.g., the NAO index of one 
experiment. The expected dimensions are c(members, 
start dates/forecast horizons). A vector with only the time dimension can
also be provided. Only monthly or lower frequency time series are supported.
See parameter freq.
  }
  \item{obs}{
Observational vector or array of time series, e.g., the NAO index of the 
observations that correspond the forecast data in \code{exp}.
The expected dimensions are c(start dates/forecast horizons) or 
c(1, start dates/forecast horizons). Only monthly or lower frequency time 
series are supported. See parameter freq.
  }
  \item{toptitle}{
Character string to be drawn as figure title.
  }
  \item{ytitle}{
Character string to be drawn as y-axis title.
  }
  \item{monini}{
Number of the month of the first time step, from 1 to 12.
  }
  \item{yearini}{
Year of the first time step.
  }
  \item{freq}{
Frequency of the provided time series: 1 = yearly, 12 = monthly, 
4 = seasonal, ... Default = 12.
  }
  \item{expname}{
Experimental dataset name.
  }
  \item{obsname}{
Name of the observational reference dataset.
  }
  \item{drawleg}{
TRUE/FALSE: whether to draw the legend or not.
  } 
  \item{fileout}{
Name of output file. Extensions allowed: eps/ps, jpeg, png, pdf, bmp 
and tiff. \cr
Default = 'output_PlotBox.ps'
  }
  \item{width}{
File width, in the units specified in the parameter size_units (inches by default). Takes 8 by default.
  }
  \item{height}{
File height, in the units specified in the parameter size_units (inches by default). Takes 5 by default.
  }
  \item{size_units}{
Units of the size of the device (file or window) to plot in. Inches ('in') by default. See ?Devices and the creator function of the corresponding device.
  }
  \item{res}{ 
Resolution of the device (file or window) to plot in. See ?Devices and the creator function of the corresponding device.
  }
  \item{...}{
    Arguments to be passed to the method. Only accepts the following
    graphical parameters:

    ann ask bg cex.lab cex.sub cin col.axis col.lab col.main col.sub cra crt csi cxy err family fg fig font font.axis font.lab font.main font.sub lend lheight ljoin lmitre mex mfcol mfrow mfg mkh oma omd omi page pin plt pty smo srt tck tcl usr xaxp xaxs xaxt xlog xpd yaxp yaxs yaxt ylbias ylog
    
    For more information about the parameters see `par`
  }
}
\value{
Generates a file at the path specified via \code{fileout}.
}
\examples{
# See examples on Load() to understand the first lines in this example
  \dontrun{
data_path <- system.file('sample_data', package = 's2dverification')
expA <- list(name = 'experiment', path = file.path(data_path,
             'model/$EXP_NAME$/$STORE_FREQ$_mean/$VAR_NAME$_3hourly',
             '$VAR_NAME$_$START_DATE$.nc'))
obsX <- list(name = 'observation', path = file.path(data_path,
             '$OBS_NAME$/$STORE_FREQ$_mean/$VAR_NAME$',
             '$VAR_NAME$_$YEAR$$MONTH$.nc'))

# Now we are ready to use Load().
startDates <- c('19851101', '19901101', '19951101', '20001101', '20051101')
sampleData <- Load('tos', list(expA), list(obsX), startDates,
                   leadtimemin = 1, leadtimemax = 4, output = 'lonlat',
                   latmin = 27, latmax = 48, lonmin = -12, lonmax = 40)
  }
  \dontshow{
startDates <- c('19851101', '19901101', '19951101', '20001101', '20051101')
sampleData <- s2dverification:::.LoadSampleData('tos', c('experiment'),
                                                c('observation'), startDates,
                                                leadtimemin = 1,
                                                leadtimemax = 4,
                                                output = 'lonlat',
                                                latmin = 20, latmax = 80,
                                                lonmin = -80, lonmax = 40)
# No example data is available over NAO region, so in this example we will 
# tweak the available data. In a real use case, one can Load() the data over 
# NAO region directly.
sampleData$lon[] <- c(40, 280, 340)
attr(sampleData$lon, 'first_lon') <- 280
attr(sampleData$lon, 'last_lon') <- 40
attr(sampleData$lon, 'data_across_gw') <- TRUE
sampleData$lat[] <- c(20, 80)
attr(sampleData$lat, 'first_lat') <- 20
attr(sampleData$lat, 'last_lat') <- 80
  }
# Now ready to compute the EOFs and project on, for example, the first 
# variability mode.
ano <- Ano_CrossValid(sampleData$mod, sampleData$obs)
nao <- NAO(ano$ano_exp, ano$ano_obs, sampleData$lon, sampleData$lat)
# Finally plot the nao index
PlotBoxWhisker(nao$NAO_exp, nao$NAO_obs, "NAO index, DJF", "NAO index (PC1) TOS", 
               monini = 12, yearini = 1985, freq = 1, "Exp. A", "Obs. X")
}
\author{
History:\cr
0.1  -  2013-09  (F. Lienert, \email{flienert at ic3.cat})  -  Original code\cr
0.2  -  2015-03  (L. Batte, \email{lauriane.batte at ic3.cat})  -  Removed all\cr
normalization for sake of clarity.
1.0  -  2016-03  (N. Manubens, \email{nicolau.manubens at bsc.es})  -  Formatting to R CRAN
}
\seealso{
EOF, ProjectField, NAO
}
\keyword{datagen}
