% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.saeTrafo.R
\name{estimators}
\alias{estimators}
\alias{estimators.saeTrafo}
\title{Presents point, MSE and CV estimates}
\usage{
estimators(object, MSE, CV, ...)

\method{estimators}{saeTrafo}(object, MSE = FALSE, CV = FALSE, ...)
}
\arguments{
\item{object}{an object of type 'saeTrafo', representing point and,
if chosen, MSE estimates.}

\item{MSE}{optional logical. If \code{TRUE}, MSE estimates are added to the
data frame of point estimates. Defaults to \code{FALSE}.}

\item{CV}{optional logical. If \code{TRUE}, coefficients of variation are
added to the data frame of point estimates. Defaults to \code{FALSE}.}

\item{...}{other parameters that can be passed to function \code{estimators}.}
}
\value{
The return of \code{estimators.saeTrafo} is an object of type
'estimators.saeTrafo' with point and/or MSE estimates and/or calculated CV's
from \code{saeTrafoObject$ind} and, if chosen, \code{saeTrafoObject$MSE}.
These objects contain two elements, one data frame
\code{ind} and a character naming the indicator or indicator group
\code{ind_name}.
}
\description{
Function \code{estimators} is a generic function used to present point and
mean squared error (MSE) estimates. Furthermore, it calculates from both the
coefficients of variation (CV).

Method \code{estimators.saeTrafo} presents point and MSE estimates.
Coefficients of variation are calculated using these estimators. The returned
object is suitable for printing with the method
\code{print.estimators.saeTrafo}.
}
\details{
Objects of class 'estimators.saeTrafo' have methods for following
generic functions: \code{head} and \code{tail} (for default documentation,
see \code{\link[utils]{head}}, \code{\link[utils]{tail}}),
\code{as.matrix} (for default documentation, see \code{\link[base]{matrix}}),
\code{as.data.frame} (for default documentation, see
\code{\link[base]{as.data.frame}}), \code{subset} (for default documentation,
see \code{\link[base]{subset}}).
}
\examples{

\donttest{
# Example for presenting point, MSE, and CV estimates for a 'saeTrafo' object

# Load Data
data("eusilcA_smp")
data("pop_area_size")
data("pop_mean")
data("pop_cov")

# Nested error regression model
NER_model <- NER_Trafo(fixed = eqIncome ~ gender + eqsize + cash +
                       self_empl + unempl_ben + age_ben + surv_ben +
                       sick_ben + dis_ben + rent + fam_allow + house_allow +
                       cap_inv + tax_adj,
                       smp_domains = "district",
                       pop_area_size = pop_area_size,
                       pop_mean = pop_mean, pop_cov = pop_cov,
                       smp_data = eusilcA_smp, MSE = TRUE)

sae_mean <- estimators(NER_model, MSE = TRUE, CV = TRUE)
class(sae_mean)

# use generic functions for estimators.saeTrafo object
print(sae_mean)
head(sae_mean)
tail(sae_mean)
as.matrix(sae_mean)
as.data.frame(sae_mean)
subset(sae_mean)
}

}
\seealso{
\code{\link{saeTrafoObject}},  \code{\link{NER_Trafo}}
}
