% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_generics.R
\docType{data}
\name{knee.saemix}
\alias{knee.saemix}
\title{Knee pain data}
\format{
This data frame contains the following columns:
\describe{
\item{id}{subject index in file}
\item{time}{time of measurement (in days)}
\item{y}{knee pain (0=none to 4=severe)}
\item{Age}{patient age (scaled and centered)}
\item{Sex}{patient gender (0=male, 1=female)}
\item{RD}{moderate knee pain (defined as pain score 2 or more)}
\item{treatment}{treatment indicator (0=placebo, 1=treatment)}
\item{Age2}{patient age, squared (Age^2)}
}
#'
}
\source{
catdata package in R
}
\usage{
knee.saemix
}
\description{
The \code{knee.saemix} data represents pain scores recorded in a clinical study
in 127 patients with sport related injuries treated with two different therapies.
After 3,7 and 10 days of treatment the pain occuring during knee movement was observed.
}
\details{
The data in the \code{knee.saemix} was reformatted from the knee dataset provided by the
catdata package (see data(knee, package="catdata")). A time column was added representing the day
of the measurement (with 0 being the baseline value) and each observation corresponds to a different
line in the dataset. Treatment was recoded as 0/1 (placebo/treatment), gender as 0/1 (male/female)
and Age2 represents the squared of centered Age.

Please refer to the PDF documentation (chapter 4, section 4.6) for more details on the analysis,
including examples of diagnostic plots.
}
\references{
G Tutz (2012), Regression for Categorical Data, Cambridge University Press.

#' @examples
data(knee.saemix)

#' @keywords datasets
}
