% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_safe.R
\name{insert_dataset}
\alias{insert_dataset}
\title{Inserts local copies of files from a dataset into a SAFE data directory}
\usage{
insert_dataset(record_id, files)
}
\arguments{
\item{record_id}{A SAFE dataset record id}

\item{files}{A vector of files to insert into the data directory}
}
\description{
If files are embargoed or restricted, then users may request the
datafiles from the authors. This function allows provided files
to be incorporated into a SAFE data directory, so that they will
then work seamlessly alongside openly available data.
}
\examples{
   set_example_safe_dir()
   files <- system.file("safedata_example_dir",
                        "template_ClareWfunctiondata.xlsx",
                        package = "safedata")
   insert_dataset(1237719, files)
   dat <- load_safe_data(1237719, "Data")
   str(dat)
   unset_example_safe_dir()
}
