% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zTest.R
\name{computeNPlanSafeZ}
\alias{computeNPlanSafeZ}
\title{Helper function: Computes the planned sample size based on the minimal clinical relevant mean
difference, alpha and beta}
\usage{
computeNPlanSafeZ(
  meanDiffMin,
  beta = 0.2,
  alpha = 0.05,
  alternative = c("two.sided", "less", "greater"),
  testType = c("oneSample", "paired", "twoSample"),
  sigma = 1,
  kappa = sigma,
  ratio = 1,
  nSim = 1000L,
  nBoot = 1000L,
  parameter = NULL,
  pb = TRUE,
  nMax = 1e+08
)
}
\arguments{
\item{meanDiffMin}{numeric that defines the minimal relevant mean difference, the smallest population mean
that we would like to detect.}

\item{beta}{numeric in (0, 1) that specifies the tolerable type II error control necessary to calculate both "n"
and "phiS". Note that 1-beta defines the power.}

\item{alpha}{numeric in (0, 1) that specifies the tolerable type I error control --independent on n-- that the
designed test has to adhere to. Note that it also defines the rejection rule e10 > 1/alpha.}

\item{alternative}{a character string specifying the alternative hypothesis must be one of "two.sided" (default),
"greater" or "less".}

\item{testType}{either one of "oneSample", "paired", "twoSample".}

\item{sigma}{numeric > 0 representing the assumed population standard deviation used for the test.}

\item{kappa}{the true population standard deviation. Default kappa=sigma.}

\item{ratio}{numeric > 0 representing the randomisation ratio of condition 2 over condition 1. If testType
is not equal to "twoSample", or if nPlan is of length(1) then ratio=1.}

\item{nSim}{integer > 0, the number of simulations needed to compute power or the number of samples paths
for the safe z test under continuous monitoring.}

\item{nBoot}{integer > 0 representing the number of bootstrap samples to assess the accuracy of
approximation of the power, the number of samples for the safe z test under continuous monitoring,
or for the computation of the logarithm of the implied target.}

\item{parameter}{optional test defining parameter. Default set to \code{NULL}.}

\item{pb}{logical, if \code{TRUE}, then show progress bar.}

\item{nMax}{integer > 0, maximum sample size of the (first) sample in each sample path.}
}
\value{
a list which contains at least nPlan and an adapted bootObject of class  \code{\link[boot]{boot}}.
}
\description{
Helper function: Computes the planned sample size based on the minimal clinical relevant mean
difference, alpha and beta
}
\examples{
computeNPlanSafeZ(0.7, 0.2, nSim=10)
}
