% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zTest.R
\name{designFreqZ}
\alias{designFreqZ}
\title{Design a Frequentist Z-Test}
\usage{
designFreqZ(
  meanDiffMin,
  alternative = c("two.sided", "greater", "less"),
  alpha = 0.05,
  beta = 0.2,
  testType = c("oneSample", "paired", "twoSample"),
  ratio = 1,
  sigma = 1,
  h0 = 0,
  kappa = sigma,
  lowN = 3L,
  highN = 100L,
  ...
)
}
\arguments{
\item{meanDiffMin}{numeric that defines the minimal relevant mean difference, the smallest population mean
that we would like to detect.}

\item{alternative}{a character string specifying the alternative hypothesis must be one of "two.sided" (default),
"greater" or "less".}

\item{alpha}{numeric in (0, 1) that specifies the tolerable type I error control --independent on n-- that the
designed test has to adhere to. Note that it also defines the rejection rule e10 > 1/alpha.}

\item{beta}{numeric in (0, 1) that specifies the tolerable type II error control necessary to calculate both "n"
and "phiS". Note that 1-beta defines the power.}

\item{testType}{either one of "oneSample", "paired", "twoSample".}

\item{ratio}{numeric > 0 representing the randomisation ratio of condition 2 over condition 1. If testType
is not equal to "twoSample", or if nPlan is of length(1) then ratio=1.}

\item{sigma}{numeric > 0 representing the assumed population standard deviation used for the test.}

\item{h0}{numeric, represents the null hypothesis, default h0=0.}

\item{kappa}{the true population standard deviation. Default kappa=sigma.}

\item{lowN}{integer that defines the smallest n of our search space for n.}

\item{highN}{integer that defines the largest n of our search space for n. This might be the
largest n that we are able to fund.}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
returns a 'freqZDesign' object.
}
\description{
Computes the number of samples necessary to reach a tolerable type I and type II error for the
frequentist z-test.
}
\examples{
freqDesign <- designFreqZ(meanDiffMin = 0.5, highN = 100)
freqDesign$nPlan
freqDesign2 <- designFreqZ(meanDiffMin = 0.2, lowN = 32, highN = 200)
freqDesign2$nPlan
}
