% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logRankTest.R
\name{logrankSingleEExact}
\alias{logrankSingleEExact}
\title{Helper function computes single component of the exact logrank e-value}
\usage{
logrankSingleEExact(obs0, obs1, y0, y1, thetaS, theta0 = 1, ...)
}
\arguments{
\item{obs0}{integer, number of observations in the control group.}

\item{obs1}{integer, number of observations in the treatment group.}

\item{y0}{integer, total number of participants in the control group.}

\item{y1}{integer, total number of participants in the treatment group.}

\item{thetaS}{numeric > 0 represents the safe test defining (GROW) alternative
hypothesis obtained from \code{designSafeLogrank()}.}

\item{theta0}{numeric > 0 represents the null hypothesis. Default theta0=1.}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
Returns a list containing at least the following components:
\describe{
  \item{logP0}{Log likelihood of Fisher's hypergeometric at the null}
  \item{logEValueLess}{Log likelihood of Fisher's hypergeometric at the alternative}
  \item{logEValueGreater}{Log likelihood of Fisher's hypergeometric at 1/alternative}
}
}
\description{
Helper function computes single component of the exact logrank e-value
}
\examples{
#'
y0Vector <- c(5, 4, 3, 3, 2, 1)
y1Vector <- c(5, 5, 4, 2, 2, 0)
obs0Vector <- c(1, 1, 0, 1, 0, 1)
obs1Vector <- c(0, 0, 1, 0, 1, 0)

logEValueGreater <- logEValueLess <- vector("numeric", length(y0Vector))

for (i in seq_along(y0Vector)) {
  tempResult <- logrankSingleEExact(obs0=obs0Vector[i], obs1=obs1Vector[i],
                                    y0=y0Vector[i], y1=y1Vector[i],
                                    thetaS=0.7, theta0=1)
  logEValueLess[i] <- tempResult[["logEValueLess"]]
  logEValueGreater[i] <- tempResult[["logEValueGreater"]]
}

eValueLess <- exp(sum(logEValueLess))
eValueLess #1.116161
eValueGreater <- exp(sum(logEValueGreater))
eValueGreater # 0.7665818
eValue <- 1/2*eValueLess + 1/2*eValueGreater
eValue # 0.9413714

}
