% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe2x2Test.R
\name{safeTwoProportionsTest}
\alias{safeTwoProportionsTest}
\alias{safe.prop.test}
\title{Perform a Safe Test for Two Proportions with Stream Data}
\usage{
safeTwoProportionsTest(
  ya,
  yb,
  designObj = NULL,
  wantConfidenceSequence = FALSE,
  ciValue = NULL,
  confidenceBoundGridPrecision = 20,
  logOddsConfidenceSearchBounds = c(0.01, 5),
  pilot = FALSE
)

safe.prop.test(
  ya,
  yb,
  designObj = NULL,
  wantConfidenceSequence = FALSE,
  ciValue = NULL,
  confidenceBoundGridPrecision = 20,
  logOddsConfidenceSearchBounds = c(0.01, 5),
  pilot = FALSE
)
}
\arguments{
\item{ya}{positive observations/ events per data block in group a: a numeric with integer values
between (and including) 0 and \code{na}, the number of observations in group a per block.}

\item{yb}{positive observations/ events per data block in group b: a numeric with integer values
between (and including) 0 and \code{nb}, the number of observations in group b per block.}

\item{designObj}{a safe test design for two proportions retrieved through \code{\link{designSafeTwoProportions}()}.}

\item{wantConfidenceSequence}{logical that can be set to true when the user wants a safe confidence
sequence to be estimated.}

\item{ciValue}{coverage of the safe confidence sequence; default \code{NULL}, if NULL
calculated as \code{1 - designObj[["alpha"]]}.}

\item{confidenceBoundGridPrecision}{integer specifying the grid precision used to search for the confidence
bounds. Default 20.}

\item{logOddsConfidenceSearchBounds}{vector of to positive doubles specifying the upper and lower bound of the grid
to search over for finding the confidence bound for the logOddsRatio restriction. Default \code{(0.01, 5)}.}

\item{pilot}{logical that can be set to true when performing an exploratory analysis
without a \code{designObj}; only allows for \code{na = nb = 1}.}
}
\value{
Returns an object of class 'safeTest'. An object of class 'safeTest' is a list containing at least the
following components:

\describe{
  \item{n}{The realised sample size(s).}
  \item{eValue}{the e-value of the safe test.}
  \item{dataName}{a character string giving the name(s) of the data.}
  \item{designObj}{an object of class "safeDesign" described in \code{\link{designSafeTwoProportions}()}.}
}
}
\description{
Perform a safe test for two proportions (a 2x2 contingency table test) with a
result object retrieved through the design function for planning an experiment to compare
two proportions in this package, \code{\link{designSafeTwoProportions}()}.
}
\examples{
#balanced design
yb <- c(1,0,1,1,1,0,1)
ya <- c(1,0,1,0,0,0,1)
safeDesign <- designSafeTwoProportions(na = 1,
                                       nb = 1,
                                       beta = 0.20,
                                       delta = 0.6,
                                       alternativeRestriction = "none",
                                       M = 1e1)
safeTwoProportionsTest(ya = ya, yb = yb, designObj = safeDesign)

#pilot
safeTwoProportionsTest(ya = ya, yb = yb, pilot = TRUE)

#unbalanced design
yb <- c(1,0,1,1,1,0,1)
ya <- c(2,2,1,2,0,2,2)
safeDesign <- designSafeTwoProportions(na = 2,
                                       nb = 1,
                                       beta = 0.20,
                                       delta = 0.6,
                                       alternativeRestriction = "none",
                                       M = 1e1)
safeTwoProportionsTest(ya = ya, yb = yb, designObj = safeDesign)

}
