% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zTest.R
\name{safeZ10Inverse}
\alias{safeZ10Inverse}
\title{Computes the Inverse of the Two-Sided Safe Z-Test}
\usage{
safeZ10Inverse(parameter, nEff, sigma = 1, alpha = 0.05)
}
\arguments{
\item{parameter}{optional test defining parameter. Default set to \code{NULL}.}

\item{nEff}{numeric > 0, the effective sample size.}

\item{sigma}{numeric, the assumed known standard deviation, default 1.}

\item{alpha}{numeric in (0, 1) that specifies the tolerable type I error control --independent on n-- that the
designed test has to adhere to. Note that it also defines the rejection rule e10 > 1/alpha.}
}
\value{
A number that represents a z-value. The function's domain is the positive real line and the range
is the real line, i.e., the outcome space of the z-statistic.
}
\description{
This helper function is used in \code{\link{designSafeZ}()} to find parameter. The function is the (two-sided)
inverse of 'safeZTestStat'.
}
\examples{
safeZ10Inverse(0.4, n=13)
}
