% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-matrix-as-matrix-as-vector.r
\name{matrix}
\alias{matrix}
\alias{matrix,dual-method}
\alias{array,dual-method}
\alias{as.matrix.dual}
\alias{as}
\alias{as.matrix,dual-method}
\alias{as.vector.dual}
\alias{as.vector,dual-method}
\title{Methods for `matrix`, `array`, `as.matrix` and `as.vector`}
\usage{
\S4method{matrix}{dual}(data = NA, nrow = 1, ncol = 1, byrow = FALSE, dimnames = NULL)

\S4method{array}{dual}(data = NA, dim = length(data), dimnames = NULL)

\method{as.matrix}{dual}(x, ...)

\S4method{as.matrix}{dual}(x, ...)

\method{as.vector}{dual}(x, mode = "any")

\S4method{as.vector}{dual}(x, mode = "any")
}
\arguments{
\item{data, x}{A dual object}

\item{nrow}{the desired number of rows}

\item{ncol}{the desired number of cols}

\item{byrow}{if `TRUE` the matrix is filled by rows}

\item{dimnames}{A `dimnames` attributes for a matrix or an array}

\item{dim}{A `dim` attributes for an array}

\item{...}{additional arguments (ignored)}

\item{mode}{The mode of the vector to create}
}
\value{
A dual object for `matrix` and `array`, a base object for `as.matrix` and `as.vector`.
}
\description{
Methods for `matrix`, `array`, `as.matrix` and `as.vector`
}
\details{
The default behaviour for `as.matrix` dans `as.vector` is to drop the derivatives.
This can be modified using `salad` (to use with care). The prefered method to change the
shape is to use `dim<-`.
}
\examples{
x <- dual(c(1,2,0,4))
y <- matrix(x, 2, 2)
y
as.matrix(y)
dim(x) <- c(2,2)
x
}
\seealso{
\link{shape}, \code{\link{salad}}, \link{dual-class}
}
\concept{dual}
