% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk-operation.R
\name{sf_batch_details_bulk}
\alias{sf_batch_details_bulk}
\title{Returning the Details of a Batch in a Bulk API Job}
\usage{
sf_batch_details_bulk(job_id, batch_id, api_type = c("Bulk 1.0"),
  verbose = FALSE)
}
\arguments{
\item{job_id}{character; the Salesforce Id assigned to a submitted job as 
returned by \link{sf_create_job_bulk}}

\item{batch_id}{character; the Salesforce Id assigned assigned to a submitted 
batch as returned by \link{sf_create_batches_bulk}}

\item{api_type}{character; one of "REST", "SOAP", "Bulk 1.0", "Bulk 2.0", or 
"Chatter" indicating which API to use when making the request}

\item{verbose}{logical; do you want informative messages?}
}
\value{
A \code{tbl_df}, formatted by Salesforce, with information containing 
the success or failure or certain rows in a submitted batch, unless the operation 
was query, then it is a data.frame containing the result_id for retrieving the recordset.
}
\description{
This function returns detailed (row-by-row) information on an existing batch
which has already been submitted to Bulk API Job
}
\note{
This is a legacy function used only with Bulk 1.0.
}
\examples{
\dontrun{
job_info <- sf_create_job_bulk(operation = "query", object = "Account")
soql <- "SELECT Id, Name FROM Account LIMIT 10"
batch_query_info <- sf_submit_query_bulk(job_id = job_info$id, soql = soql)
batch_details <- sf_batch_details_bulk(job_id=batch_query_info$jobId,
                                       batch_id=batch_query_info$id)
sf_close_job_bulk(job_info$id)
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}
}
