% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-org.R
\name{sf_find_duplicates}
\alias{sf_find_duplicates}
\title{Find Duplicate Records}
\usage{
sf_find_duplicates(search_criteria, object_name,
  include_record_details = FALSE, guess_types = TRUE,
  verbose = FALSE)
}
\arguments{
\item{search_criteria}{\code{list}; a list of fields and their values that would 
constitute a match. For example, list(FirstName="Marc", Company="Salesforce")}

\item{object_name}{character; the name of one Salesforce objects that the 
function is operating against (e.g. "Account", "Contact", "CustomObject__c")}

\item{include_record_details}{logical; get fields and values for records detected 
as duplicates by setting this property to \code{TRUE}. Get only record IDs for 
records detected as duplicates by setting this property to \code{FALSE}}

\item{guess_types}{logical; indicating whether or not to use \code{col_guess()} 
to try and cast the data returned in the query recordset. TRUE uses \code{col_guess()} 
and FALSE returns all values as character strings.}

\item{verbose}{logical; do you want informative messages?}
}
\value{
\code{tbl_df} of records found to be duplicates by the match rules
}
\description{
Performs rule-based searches for duplicate records.
}
\note{
You must have actived duplicate rules for the supplied object before running 
this function. The \code{object_name} argument refers to using that object's duplicate 
rules on the search criteria to determine which records in other objects are duplicates.
}
\examples{
\dontrun{
# use the duplicate rules associated with the Lead object on the search 
# criteria (email) in order to find duplicates
found_dupes <- sf_find_duplicates(search_criteria = 
                                    list(Email="bond_john@grandhotels.com"),
                                  object_name = "Lead")
                                  
# now look for duplicates on email using the Contact object's rules
found_dupes <- sf_find_duplicates(search_criteria = 
                                    list(Email="bond_john@grandhotels.com"),
                                  object_name = "Contact")
}
}
