% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compatibility.R
\name{rforcecom.bulkQuery}
\alias{rforcecom.bulkQuery}
\title{salesforcer's backwards compatible version of rforcecom.bulkQuery}
\usage{
rforcecom.bulkQuery(
  session,
  soqlQuery,
  object,
  interval_seconds = 5,
  max_attempts = 100,
  verbose = FALSE
)
}
\arguments{
\item{session}{\code{list}; a list containing "sessionID", "instanceURL", and "
apiVersion" as returned by \code{RForcecom::rforcecom.login()}. This argument is
ignored in all backward compatible calls because the authorization credentials 
are stored in an environment internal to the salesforcer package, so it is no longer 
necessary to pass the session in each function call.}

\item{soqlQuery}{character; a string defining a SOQL query (e.g. "SELECT Id, Name FROM Account")}

\item{object}{character; the name of one Salesforce objects that the 
function is operating against (e.g. "Account", "Contact", "CustomObject__c")}

\item{interval_seconds}{an integer defining the seconds between attempts to check for job completion}

\item{max_attempts}{an integer defining then max number attempts to check for job completion before stopping}

\item{verbose}{logical; do you want informative messages?}
}
\value{
A \code{data.frame} of the recordset returned by query
}
\description{
salesforcer's backwards compatible version of rforcecom.bulkQuery
}
