% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_Parameter.R
\name{set_Parameter}
\alias{set_Parameter}
\title{Set Profile- and Grain-Specific Model Parameters.}
\usage{
set_Parameter(book, parameter, type)
}
\arguments{
\item{book}{\link{list} object, rule book to be edited.}

\item{parameter}{\link{character} scalar, keyword defining the parameter to
be defined. Some
parameters can be described by more than one function, see details.}

\item{type}{\link{character} scalar, keyword defining the distribution
function used to describe the parameter. See details for available
keywords, default is \code{"exact"}.}
}
\value{
A \link{list} object.
}
\description{
The function defines one model parameter used to generate a set of
virtual grains. A parameter is defined in a probabilistic way, as parametric
distribution function. Each parameter of the distribution function can be
changed through time using \link{set_Rule}.
}
\details{
The following parameter types are available:
\itemize{
\item \code{exact}: parameter does not vary at all. No additional
parameters needed except for vector \code{value}, defining the
constant values for corresponding depths.
\item \code{uniform}: parameter varies following a uniform distribution.
The following additional parameter vectors are required: \code{min}
(minimum) and \code{max} (maximum)
\item \code{normal}: parameter varies following a normal distribution,
which is defined by mean and standard deviation
\item \code{gamma}: parameter varies following a gamma distribution,
defined by shape parameter, scale parameter)
and offset (defining constant offset of values)
}
}
\examples{
## get empty rule book
book_1 <- get_RuleBook(book = "empty")

## set density from default "normal" to "exact"
book_2 <- set_Parameter(book = book_1,
                        parameter = "density",
                        type = "exact")

book_1$density$density_1$type
book_2$density$density_1$type

}
\author{
Michael Dietze, GFZ Potsdam (Germany)
}
