% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.data.shp.r
\name{load.data.shp}
\alias{load.data.shp}
\title{Load shapefiles into \code{sf}s}
\usage{
load.data.shp(sampling.file,
       ssh.file,
       reporting.file)
}
\arguments{
\item{sampling.file}{Path to the sampling layer. The sampling layer should be a point \code{sf} object that contains an attribute to be interpolated.}

\item{ssh.file}{Path to the SSH layer. The SSH layer should be a polygon \code{sf} object.}

\item{reporting.file}{Path to the reporting layer. The reporting layer should be a polygon \code{sf} object.}
}
\value{
A list of \code{sf} objects.
}
\description{
Convert shapefiles into a list of \code{sf} objects.
}
\examples{
hs.sampling.name <- system.file("extdata", "hs.sampling.shapefile.shp",
                                package="sandwichr")
hs.ssh.name <- system.file("extdata", "hs.ssh.shapefile.shp",
                           package="sandwichr")
hs.reporting.name <- system.file("extdata", "hs.reporting.shapefile.shp",
                                 package="sandwichr")

hs.data <- load.data.shp(sampling.file=hs.sampling.name,
                         ssh.file=hs.ssh.name,
                         reporting.file=hs.reporting.name)

}
