% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.data.shp.r
\name{load.data.shp}
\alias{load.data.shp}
\title{Load shapefiles into \code{sf}s}
\usage{
load.data.shp(sampling.file,
       ssh.file,
       reporting.file)
}
\arguments{
\item{sampling.file}{Path to the sampling layer. The sampling layer should be a point \code{sf} object that contains an attribute to be interpolated.}

\item{ssh.file}{Path to the SSH layer. The SSH layer should be a polygon \code{sf} object.}

\item{reporting.file}{Path to the reporting layer. The reporting layer should be a polygon \code{sf} object.}
}
\value{
A list of \code{sf} objects.
}
\description{
Convert shapefiles into a list of \code{sf} objects.
}
\examples{
sim.sampling.name <- system.file("extdata", "sim.sampling.shp",
                                 package="sandwichr")
sim.ssh.name <- system.file("extdata", "sim.ssh.shp",
                            package="sandwichr")
sim.reporting.name <- system.file("extdata", "sim.reporting.shp",
                                  package="sandwichr")

sim.data <- load.data.shp(sampling.file=sim.sampling.name,
                          ssh.file=sim.ssh.name,
                          reporting.file=sim.reporting.name)

}
